#include <TDSConcentration.h>                                  //Βιβλιοθήκες
#include <Liquid_Crystal.h>
#include <Potentiometer.h>


TDSConcentration myTDS(A1);                                    // Ορισμός της θύρας του αισθητήρα TDS


LiquidCrystal myLCD(0x27, 16, 2);                              // Ορισμός της LCD. Η σύνδεση πρέπει να γίνει στη θύρα I2C


int potPort = A0;                                              // Ορισμός της θύρας και των ορίων των τιμών του ποτενσιόμετρου
float potMin = -0.0250;
float potMax = 0.0250;
Potentiometer myPot(potPort, potMin, potMax);

void setup() 
{
  myTDS.begin();                                                // Έναρξη του αισθητήρα περιεκτικότητας
  myLCD.begin();                                                // Εκκίνηση της LCD
}

void loop() {
  float concentration = myTDS.readConcentration();              // Ανάγνωση %w/w περιεκτικότητας από τον αισθητήρα
  float calib = myPot.read();                                   // Ανάγνωση της τιμής του ποτενσιόμετρου (για την βαθμονόμηση)

  
  float adjustedConcentration = concentration + calib;          // "Βαθμονομημένη" περιεκτικότητα βάσει της τιμής του ποτενσιόμετρου


  myLCD.Text(String(adjustedConcentration, 4).c_str(), 0, 0);    // Εμφάνιση προσαρμοσμένης τιμής περιεκτικότητας στην οθόνη LCD. Τιμή με 4 δεκαδικά ψηφία
  myLCD.Text("%w/w", 6, 0);                                      // Εμφάνιση κειμένου "%w/w"


  delay(500);                                                     // Καθυστέρηση για σταθερότητα
}
